﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class ElectricOvenController : MonoBehaviour
{
    public static ElectricOvenController instance;

    public GameObject[] objectsToActivateWhenFlagIsAcquired;

    protected bool isActive = false;
    protected GameObject panel;
    protected GameObject selector;
    protected Transform options;
    protected AudioSource audioSource;

    protected bool silenced;
    protected bool isBaking;
    protected int selectedOption;

    protected int restTime;
    protected int temperature;
    protected int bakeTime;

    protected float animationRestTime;
    protected float animationTemperature;
    protected float animationBakeTime;

    private void OnEnable()
    {
        instance = this;
        isBaking = false;
        audioSource = GetComponent<AudioSource>();
        panel = transform.GetChild(0).gameObject;
        selector = panel.transform.GetChild(0).gameObject;
        options = panel.transform.GetChild(1);
    }

    public void Activate()
    {
        isActive = true;
        silenced = false;

        panel.SetActive(true);

        SetValue(0, (restTime = 0) + "m");
        SetValue(1, (temperature = 293) + "K");
        SetValue(2, (bakeTime= 0) + "m");
        SelectOption(0);

        audioSource.volume = 0f;
        audioSource.Play();
    }

    public void Deactivate()
    {
        isActive = false;
        panel.SetActive(false);
        silenced = true;
    }

    protected void SelectOption(int option)
    {
        selectedOption = option;
        Transform optionTransform = options.GetChild(selectedOption);
        selector.transform.position = optionTransform.position + 16f * Vector3.up;
    }

    protected void SetValue(int idx, string value)
    {
        options.GetChild(idx).GetChild(1).GetComponent<Text>().text = value;
    }

    // Update is called once per frame
    void Update()
    {
        audioSource.volume = Mathf.Lerp(audioSource.volume, silenced ? 0f : .5f, 0.05f);

        if (!isActive)
        {
            return;
        }

        if (isBaking)
        {
            if (animationRestTime > 0f)
            {
                animationRestTime = Math.Max(0f, animationRestTime - 10f * Time.deltaTime);
                SetValue(0, (int)animationRestTime + "m");
            }
            else if (animationTemperature < temperature)
            {
                animationTemperature = Math.Min(temperature, animationTemperature + 20f * Time.deltaTime);
                SetValue(1, (int)(animationTemperature) + "K");
            }
            else if (animationBakeTime > 0f)
            {
                animationBakeTime = Math.Max(0f, animationBakeTime - 10f * Time.deltaTime);
                SetValue(2, (int)(animationBakeTime) + "m");
            }
            else
            {
                isBaking = false;
                GameController.instance.StopElectricOvenMinigame();

                bool solved = restTime == 60 && temperature == 453 && bakeTime == 40;
                bool trulySolved = restTime == 40 && temperature == 523 && bakeTime == 20;

                if (trulySolved && GameController.instance.HasFlag("True Dough"))
                {
                    GameController.instance.StartDialog(new string[] { "These loafs look perfect." }, () =>
                    {
                        GameController.instance.ResetHazardCounter();
                    });
                    GameController.instance.RemoveFlag("True Dough");
                    GameController.instance.AddFlag("True Bread");

                    objectsToActivateWhenFlagIsAcquired[0].SetActive(true);
                }
                else if ((solved || trulySolved) && (GameController.instance.HasFlag("Dough") || GameController.instance.HasFlag("True Dough")))
                {
                    GameController.instance.StartDialog(new string[] { "The bread looks great." }, () =>
                    {
                        GameController.instance.ResetHazardCounter();
                    });
                    GameController.instance.RemoveFlag("True Dough");
                    GameController.instance.RemoveFlag("Dough");
                    GameController.instance.AddFlag("Bread");

                    objectsToActivateWhenFlagIsAcquired[1].SetActive(true);
                }
            }
            return;
        }

        if (Input.GetButtonDown("Left"))
        {
            SelectOption(selectedOption = (selectedOption + options.childCount - 1) % options.childCount);
        }

        if (Input.GetButtonDown("Right"))
        {
            SelectOption((selectedOption + 1) % options.childCount);
        }

        if (Input.GetButtonDown("Up"))
        {
            switch (selectedOption)
            {
                case 0:
                    SetValue(0, (restTime += 10) + "m");
                    break;

                case 1:
                    SetValue(1, (temperature += 10) + "K");
                    break;

                case 2:
                    SetValue(2, (bakeTime += 10) + "m");
                    break;
            }
        }

        if (Input.GetButtonDown("Down"))
        {
            switch (selectedOption)
            {
                case 0:
                    SetValue(0, (restTime = Math.Max(0, restTime - 10)) + "m");
                    break;

                case 1:
                    SetValue(1, (temperature = Math.Max(0, temperature - 10)) + "K");
                    break;

                case 2:
                    SetValue(2, (bakeTime = Math.Max(0, bakeTime - 10)) + "m");
                    break;
            }
        }

        if (Input.GetButtonDown("Interact"))
        {
            if (selectedOption == 3)
            {
                bool solved = restTime == 60 && temperature == 453 && bakeTime == 40;
                bool trullySolved = restTime == 40 && temperature == 523 && bakeTime == 20;

                if ((solved || trullySolved) && (GameController.instance.HasFlag("Dough") || GameController.instance.HasFlag("True Dough")))
                {
                    isBaking = true;

                    SetValue(0, (int)(animationRestTime = restTime) + "m");
                    SetValue(1, (int)(animationTemperature = 293) + "K");
                    SetValue(2, (int)(animationBakeTime = bakeTime) + "m");
                }
                else
                {
                    isActive = false;
                    GameController.instance.StartDialog(new string[] { "It feels like Richard disagrees with these settings." }, () =>
                    {
                        isActive = true;
                    });
                }
            }
            else if (selectedOption == 4)
            {
                GameController.instance.StopElectricOvenMinigame();
            }
        }
    }
}
